/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.SimpleBlockProviderConfig;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class ArchFeature
extends Feature<SimpleBlockProviderConfig> {
    protected long seed;
    protected static FastNoise fastNoise;

    public ArchFeature(Codec<SimpleBlockProviderConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        int curveLength = 35;
        BlockPos.Mutable mutable2 = new BlockPos.Mutable();
        for (int z = -curveLength; z <= curveLength; ++z) {
            mutable2.func_181079_c(mutable.func_177958_n(), 0, mutable.func_177952_p() + z);
            int height = ArchFeature.getArchHeight(z);
            mutable2.func_189534_c(Direction.UP, height + pos.func_177956_o() + 15);
            BlockPos.Mutable thicknessPos = new BlockPos.Mutable().func_189533_g((Vector3i)mutable2);
            int horizontalThicknessTotal = 4;
            for (int archHorizontalThickness = -horizontalThicknessTotal; archHorizontalThickness <= horizontalThicknessTotal; ++archHorizontalThickness) {
                thicknessPos.func_223471_o(mutable2.func_177958_n() + archHorizontalThickness);
                for (int archVerticalThickness = 0; archVerticalThickness <= 4; ++archVerticalThickness) {
                    world.func_180501_a((BlockPos)thicknessPos, config.getBlockProvider().func_225574_a_(random, (BlockPos)thicknessPos), 2);
                    thicknessPos.func_189536_c(Direction.DOWN);
                }
                thicknessPos.func_185336_p(mutable2.func_177956_o() + Math.abs(archHorizontalThickness) * 2);
            }
        }
        return true;
    }

    public static int getArchHeight(int z) {
        return (int)((double)(-z * z) * 0.2);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }
}

